texture	g_tex0;
float	g_power;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
	Texture = (g_tex0);
    MIPFILTER	= LINEAR;
    MAGFILTER	= LINEAR;
    MINFILTER	= LINEAR;
    AddressU	= BORDER;
    AddressV	= BORDER;
};


struct vs_params
{ 
     float4 position 	: POSITION0;
     float2 tex		: TEXCOORD0;
};


//VERTEX SHADER
void vs( in vs_params IN, out vs_params OUT ) 
{
	OUT.position = IN.position;
	
	OUT.tex = IN.tex;
}

//PIXEL SHADER
float4 ps( float2 tex : TEXCOORD0 ) : COLOR
{
	float4 TextureColor = tex2D( tex0 , tex );

	return TextureColor + g_power;
}

technique Default
{
    pass P0
    {
        VertexShader	= compile vs_3_0 vs();
        PixelShader	= compile ps_2_0 ps();
    }
}